---
title: Set up 1.1.1.1 on Linux · Cloudflare 1.1.1.1 docs
description: Learn how to set up 1.1.1.1 as your DNS resolver on a Linux system.
lastUpdated: 2025-08-20T18:25:25.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/1.1.1.1/setup/linux/
  md: https://developers.cloudflare.com/1.1.1.1/setup/linux/index.md
---

Before you begin, take note of any DNS addresses you might have set up, and save them in a safe place in case you need to use them later.

Consider the sections below to set up 1.1.1.1 using either the [command line interface (CLI)](#use-command-line-interface-cli) or a [graphical user interface (GUI)](#use-graphical-user-interface-gui) of your preference.

## Use command line interface (CLI)

Choose whether you want to use 1.1.1.1 or 1.1.1.1 For Families, and replace `1.1.1.1` with the corresponding [IPv4 or IPv6 address](https://developers.cloudflare.com/1.1.1.1/ip-addresses/) accordingly.

### `resolv.conf`

Usually, `/etc/resolv.conf` is where you can configure the resolver IPs that your system is using.

In that case, you can use the following one-line command to specify `1.1.1.1` as your DNS resolver and `1.0.0.1` as backup:

```sh
echo -e "nameserver 1.1.1.1\nnameserver 1.0.0.1" | sudo tee /etc/resolv.conf
```

Warning

Note that other systems, such as dynamic host configuration protocol (DHCP), may automatically write to `/etc/resolv.conf` and change that configuration. In those cases, consider changing your network settings or DHCP to use `1.1.1.1`.

Alternatively, you can use an editor (`nano` or `vim`, for example) to manually edit the file.

### `systemd-resolved`

If you use `systemd-resolved` utility and the resolver IPs configuration is in `/etc/systemd/resolved.conf`, consider the steps below:

1. Run the following command, replacing `<EDITOR>` with your preferred editor.

```sh
sudo <EDITOR> /etc/systemd/resolved.conf
```

1. In the editor, add or edit the following lines:

```txt
[Resolve]
DNS=1.1.1.1
```

To use DNS over TLS, add `#one.one.one.one` and set `DNSOverTLS` to `yes`, as in the following example:

```txt
[Resolve]
DNS=1.1.1.1#one.one.one.one
DNSOverTLS=yes
```

## Use graphical user interface (GUI)

### GNOME

1. Go to **Show Applications** > **Settings** > **Network**.

2. Select the adapter you want to configure — like your Ethernet adapter or Wi-Fi card — and select the **Settings** button.

3. On the **IPv4** tab > **DNS** section, disable the **Automatic** toggle.

4. Depending on what you want to configure, choose one of the following DNS addresses for IPv4:

   Use 1.1.1.1 resolver

   ```txt
   1.1.1.1
   1.0.0.1
   ```

   Block malware with 1.1.1.1 for Families

   ```txt
   1.1.1.2
   1.0.0.2
   ```

   Block malware and adult content with 1.1.1.1 for Families

   ```txt
   1.1.1.3
   1.0.0.3
   ```

5. Go to **IPv6**.

6. Depending on what you want to configure, choose one of the following DNS addresses for IPv6:

   Use 1.1.1.1 resolver

   ```txt
   2606:4700:4700::1111
   2606:4700:4700::1001
   ```

   Block malware with 1.1.1.1 for Families

   ```txt
   2606:4700:4700::1112
   2606:4700:4700::1002
   ```

   Block malware and adult content with 1.1.1.1 for Families

   ```txt
   2606:4700:4700::1113
   2606:4700:4700::1003
   ```

7. Select **Apply**.

### KDE Plasma

1. Go to **System Settings** > **Wi-Fi & Internet** > **Wi-Fi & Networking**. (or **Connections**, if on Plasma 5)

2. Select the connection you want to configure - like your current connected network.

3. On the **IPv4** tab, select the **Method** drop-down menu > *Automatic (Only addresses)*.

4. Select the text box next to **DNS servers**.

5. Depending on what you want to configure, choose one of the following DNS addresses for IPv4:

   Use 1.1.1.1 resolver

   ```txt
   1.1.1.1
   1.0.0.1
   ```

   Block malware with 1.1.1.1 for Families

   ```txt
   1.1.1.2
   1.0.0.2
   ```

   Block malware and adult content with 1.1.1.1 for Families

   ```txt
   1.1.1.3
   1.0.0.3
   ```

6. On the **IPv6** tab, select the **Method** drop-down menu > *Automatic (Only addresses)*.

7. Select the text box next to **DNS servers**.

8. Depending on what you want to configure, choose one of the following DNS addresses for IPv6:

   Use 1.1.1.1 resolver

   ```txt
   2606:4700:4700::1111
   2606:4700:4700::1001
   ```

   Block malware with 1.1.1.1 for Families

   ```txt
   2606:4700:4700::1112
   2606:4700:4700::1002
   ```

   Block malware and adult content with 1.1.1.1 for Families

   ```txt
   2606:4700:4700::1113
   2606:4700:4700::1003
   ```

9. Select **Apply**.

Note

Setting up a static IP address to configure a DNS server may prevent you from connecting to some public Wi-Fi networks that use captive portals — these are the web pages some wireless networks employ to let users log in and use their services.

If you are experiencing connectivity issues related to captive portals:

1. Remove the static IP addresses from the device or disable the 1.1.1.1 app.
2. Connect to the Wi-Fi network.
3. Once the connection has been established, re-add the static IP addresses or enable the 1.1.1.1 app.
