---
title: API Discovery · Cloudflare API Shield docs
description: Most development teams struggle to keep track of their APIs.
  Cloudflare API Discovery helps you map out and understand your attack surface
  area.
lastUpdated: 2025-11-07T16:57:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/security/api-discovery/
  md: https://developers.cloudflare.com/api-shield/security/api-discovery/index.md
---

Most development teams struggle to keep track of their APIs. Cloudflare API Discovery helps you map out and understand your attack surface area.

## Process

Cloudflare produces a simple, trustworthy map of API endpoints through a process of path normalization.

For example, you might have thousands of APIs, but a lot of the calls look similar, such as:

* `api.example.com/profile/238`
* `api.example.com/profile/392`

Both paths serve a similar purpose — allowing users to log in to their accounts — but they are not identical. To simplify your endpoints, these examples might both map to `api.example.com/profile/*`.

API Discovery runs this process across all your traffic, generating a simple map of endpoints that might look like:

```plaintext
/api/login/{customer_identifier}
/api/auth
/api/account/{customer_identifier}
/api/password_reset
/api/logout
```

Similarly, if you have multiple subdomains that share the same set of endpoints, Cloudflare will consolidate subdomains:

```txt
us-api.example.com/api/v1/users/{var1}
de-api.example.com/api/v1/users/{var1}
fr-api.example.com/api/v1/users/{var1}
jp-api.example.com/api/v1/users/{var1}
```

We will consolidate to `{hostVar1}.example.com/api/v1/users/{var1}`.

For more technical details, see our [blog post](https://blog.cloudflare.com/ml-api-discovery-and-schema-learning/).

### Inbox view

API Shield first catalogs your discovered API endpoints in an email inbox-style view. From API Discovery, you can save endpoints to [Endpoint Management](https://developers.cloudflare.com/api-shield/management-and-monitoring/) or ignore endpoints to remove them from view.

You should save all discovered API endpoints to Endpoint Management while ignoring any potential false positives in the API Discovery results by selecting **Save** or **Ignore** on each line. Alternatively, you can bulk-select endpoints to save or ignore. You can get started with saving endpoints by saving all endpoints with a variable. Search for `var1` in the search box and add all the resulting endpoints. You can examine endpoints without path variables for accuracy later on.

By adding endpoints to Endpoint Management, you will unlock further [security](https://developers.cloudflare.com/api-shield/security/), [visibility](https://developers.cloudflare.com/api-shield/management-and-monitoring/#endpoint-analysis), and [management](https://developers.cloudflare.com/api-shield/management-and-monitoring/) features of the platform. Endpoint Management monitors the health of your API endpoints by saving, updating, and monitoring performance metrics.

To restore any errantly ignored endpoints, you can filter by **Ignored** and select **Restore**.

API Discovery is an ongoing process. Check back regularly for new API Discovery results. A badge with the number of endpoints needing review will show in the API Shield dashboard. You may see the quantities in the **Needs Review** and **Ignored** metrics change over time. As your actual API or traffic patterns to your APIs change, API Discovery results that are not saved can disappear.

Note

Cloudflare will use your feedback on the ignored endpoints to better train the API Discovery Machine Learning model in a future release.

### Machine Learning-based Discovery

Your API endpoints are discovered with both the Session Identifier-based Discovery and the Machine Learning-based Discovery.

To access Machine Learning-based Discovery:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **API Shield** > **Discovery**.
  3. Filter the source results by `Session Identifier` or `Machine Learning` to view results from each Discovery method.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Web Assets** page.

     [Go to **Web assets**](https://dash.cloudflare.com/?to=/:account/:zone/security/web-assets)

  2. Go to the **Discovery** tab.

  3. Filter the source results by `Session Identifier` or `Machine Learning` to view results from each Discovery method.

If all of your zone’s API traffic contains the session identifier that you have configured, both sources may deliver the same results due to similarities between their underlying methodology. We expect Machine Learning-based Discovery to excel in discovering API traffic regardless of whether your API uses a session identifier.

You can direct any feedback about your API Discovery results to your account team.

## Requirements

To ensure your API endpoints are successfully discovered and mapped by Cloudflare, traffic to the endpoint must meet specific operational criteria.

If an endpoint does not appear in the Discovery inbox, it is typically because the system has not observed enough valid requests over a continuous period. API Discovery only processes requests that satisfy all of the following requirements:

* The request must return a `2xx` response code from the Cloudflare edge.
* The request must not come directly from Cloudflare Workers.
* The endpoint must receive at least 500 requests within a 10-day period.

Endpoints discovered using session identifiers will be labeled as such in the Cloudflare dashboard. If the endpoints are not discovered through session identifiers, they will be discovered using our machine learning-based [API Discovery](https://developers.cloudflare.com/api-shield/security/api-discovery/).

## Availability

API Discovery is only available for Enterprise customers. If you are an Enterprise customer interested in this product, contact your account team.
