---
title: Certificate pinning · Cloudflare SSL/TLS docs
description: Learn why Cloudflare does not support HTTP public key pinning
  (HPKP) and consider an alternative solution to prevent certificate
  misissuance.
lastUpdated: 2025-08-13T10:12:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/reference/certificate-pinning/
  md: https://developers.cloudflare.com/ssl/reference/certificate-pinning/index.md
---

Cloudflare does not support HTTP public key pinning (HPKP)[1](#user-content-fn-1) for Universal, Advanced, or Custom Hostname certificates.

This is because Cloudflare regularly changes the edge certificates provisioned for your domain and - if you had HPKP enabled - your domain would go offline. Additionally, [industry experts](https://scotthelme.co.uk/im-giving-up-on-hpkp/) discourage using HPKP.

For a better solution to the problem that HPKP is trying to solve - preventing certificate misissuance - use [Certificate Transparency Monitoring](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-transparency-monitoring/). Also consider Cloudflare's blog post on [modern alternatives to certificate pinning practices](https://blog.cloudflare.com/why-certificate-pinning-is-outdated/).

To avoid downtime when pinning your certificates, use [custom certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) and select [**user-defined** bundle method](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/bundling-methodologies/#user-defined). This way you can control which CA, intermediate, and certificate will be used after renewal.

## Footnotes

1. Key pinning allows a host to instruct a browser to only accept certain public keys when communicating with it for a given period of time. [↩](#user-content-fnref-1)
