---
title: WranglerConfig · Cloudflare Style Guide
description: This component can be used to automatically generate a jsonc
  version of the toml file (or vice versa) of the Cloudflare Wrangler
  configuration file.
lastUpdated: 2025-11-10T15:01:11.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/wrangler-config/
  md: https://developers.cloudflare.com/style-guide/components/wrangler-config/index.md
---

This component can be used to automatically generate a `jsonc` version of the `toml` file (or vice versa) of the Cloudflare [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/).

## Import

```mdx
import { WranglerConfig } from "~/components";
```

## Usage

A `$today` value can be used in this component to automatically insert the today's date. This is useful for suggesting that users set the latest compatibility date.

The `removeSchema` prop can be used to remove the `$schema` reference from the generated JSON file. This can be useful if you want to add snippets of configuration files that are easier to copy paste, and are providing toml as the source config format.

If you provide jsonc as the source config format, the `removeSchema` prop will be ignored.
